/*****************************************************************************
*  LPC15xx SCT demo program for LPCXpresso board
*
*  1. Use SCT3 timer to generate a center aligned PWM output signal @ SCT3_OUT0
*  2. Every time P0_17 (sw1) goes high to low increase the duty cycle.
*  3. Every time P1_9  (sw2) goes high to low decrease the duty cycle.
*  4. SCT3_OUT0 is connected to P0_1 (blue LED).
*****************************************************************************/
#include "LPC15xx.h"

extern void SCT3_Init(void);

int main (void)
{
  static uint8_t trgsw1 = 1;
  static uint8_t trgsw2 = 1;

    LPC_SYSCON->SYSAHBCLKCTRL0 |= EN0_SWM;                     // enable the SWM clock
    LPC_SYSCON->SYSAHBCLKCTRL0 |= EN0_GPIO0 | EN0_GPIO1;       // enable clock to GPIO port 0 and 1
    LPC_SWM->PINASSIGN9        |= 0x00FF0000;                  // ASSIGN9(23:16) = FF
    LPC_SWM->PINASSIGN9        &= 0xFF01FFFF;                  // P0_1 is SCT3_OUT0, ASSIGN9(23:16)

    SCT3_Init();                                               // Initialize SCT3

    while (1)                                                  // loop forever
    {
        if (!(LPC_GPIO->PIN[0] & (1 << 17)) && trgsw1)         // P0_17 (sw1) high to low?
        {
            trgsw1 = 0;                                        // trigger sw1 low
            if (LPC_SCT3->MATCHREL[1].L < 9)
                LPC_SCT3->MATCHREL[1].L ++;                    // increase PWM dutycycle
        }
        else if ((LPC_GPIO->PIN[0] & (1 << 17)) && !trgsw1)    // P0_17 (sw1) low to high?
        {
            trgsw1 = 1;                                        // trigger sw1 high
        }

        if (!(LPC_GPIO->PIN[1] & (1 << 9)) && trgsw2)          // P1_9 (sw2) high to low?
        {
            trgsw2 = 0;                                        // trigger sw2 low
            if (LPC_SCT3->MATCHREL[1].L > 0)
                LPC_SCT3->MATCHREL[1].L --;                    // decrease PWM dutycycle
        }
        else if ((LPC_GPIO->PIN[1] & (1 << 9)) && !trgsw2)     // P1_9 (sw2) low to high?
        {
            trgsw2 = 1;                                        // trigger sw2 high
        }
    }
}
